package gov.va.med.mhv.admin.converter;

import java.util.ArrayList;
import java.util.List;

import gov.va.med.mhv.admin.dto.UserCategoryDTO;
import gov.va.med.mhv.admin.model.UserCategory;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

@Component
public class UserCategoryConverter implements Converter<UserCategory, UserCategoryDTO> {

	@Override
	public UserCategoryDTO convert(UserCategory source) {
		UserCategoryDTO target = new UserCategoryDTO();
		target.setUserCatId(source.getUserCatId());
		if (source.getCalendarCategory() != null) {
			target.setCalendarCategory(new CalendarCategoryConverter().convert(source.getCalendarCategory()));
		}

		return target;
	}

	public UserCategory convert(UserCategoryDTO source) {

		UserCategory target = new UserCategory();
		target.setUserCatId(source.getUserCatId());
		if (source.getCalendarCategory() != null) {
			target.setCalendarCategory(new CalendarCategoryConverter().convert(source.getCalendarCategory()));
		}
		return target;
	}

	public List<UserCategoryDTO> convert(List<UserCategory> source) {
		List<UserCategoryDTO> userCategoryDto = null;
		if (null != source) {
			userCategoryDto = new ArrayList<UserCategoryDTO>();

			for (UserCategory userCategory : source) {
				userCategoryDto.add(this.convert(userCategory));
			}

		}

		return userCategoryDto;
	}

}
